/*
    wallfol2.c:  with center "OK" band
*/

/*  motor ports  */
int     LEFT_MOTOR=     0;
int     RIGHT_MOTOR=    3;

/*  sensor ports  */
int     LEFT_WALL=      0;

/*  wall conditions  */
persistent int  inner_goal;
persistent int	outer_goal;

/* data capture */
persistent int data[1000];
persistent int ix;

void calibrate()
{
  int mode= 0;	/* if 0, capture inner, 
		   if 1, capture outer */
  while (1) {
    int wall= analog(LEFT_WALL);
    printf("in %d out %d wall %d\n",
	   inner_goal, outer_goal, wall);

    if (start_button()) {
      if (mode == 0) {
	inner_goal= wall;
	printf("Set inner goal to %d\n", inner_goal); 
	beep(); sleep(0.5);
	mode= 1;}
      else {
	outer_goal= wall;
	printf("Set outer goal to %d\n", outer_goal); 
	beep(); sleep(0.5);
	mode= 0;}
    }

    if (stop_button()) {
      printf("Done calibrating.\n");
      beep();
      sleep(0.5);
      break;
    }

    msleep(50L); /* give a pause for the display */
  }
}

void main()
{
  calibrate();

  ix= 0;
  
  while (1) {
    int wall= analog(LEFT_WALL);
    printf("wall is %d\n", wall);

    if (wall < outer_goal) /* too far */
      left();
    else if (wall > inner_goal)  /* too close */
      right();
    else
      straight();

    data[ix++]= wall;

    msleep(100L); /* 10 iterations per second */
  }
}


void straight()
{
  motor(LEFT_MOTOR, 100);
  motor(RIGHT_MOTOR, 100);
}

void left()
{
  motor(RIGHT_MOTOR, 100);
  motor(LEFT_MOTOR, 0);
}

void right()
{
  motor(LEFT_MOTOR, 100);
  motor(RIGHT_MOTOR, 0);
}

void dump_data()
{
  int i;

  printf("Press START to send data...\n");
  start_press();

  for (i=0; i< ix; i++) {
    printdec(data[i]);
    serial_putchar(10); serial_putchar(13);
  }

  printf("Done sending data.\n");
  beep();
}
