/*
    wallfol1.c: simple threshold-based wall follower 
    with data collection
*/

/*  motor and sensor ports  */
int     LEFT_MOTOR=     0;
int     RIGHT_MOTOR=    3;
int     LEFT_WALL=      0;

/*  wall conditions  */
persistent int goal;

/* data capture */
persistent int data[1000];
persistent int ix;

void calibrate()
{
  while (1) {
    int wall= analog(LEFT_WALL);
    printf("goal is %d; wall is %d\n", goal, wall);

    if (start_button()) {
      goal= wall; beep();
    }

    if (stop_button()) {
      printf("Set goal to %d\n", goal);
      beep(); sleep(0.5); break;
    }

    msleep(50L); /* give a pause for the display */
  }
}

void main()
{
  calibrate();

  ix= 0;
  
  while (1) {
    int wall= analog(LEFT_WALL);
    printf("goal is %d; wall is %d\n", goal, wall);

    if (wall < goal) left();  /* too far from wall -- turn in */
    else right();             /* turn away from wall */

    data[ix++]= wall;         /* take data sample */

    msleep(100L);             /* 10 iterations per second */
  }
}


void left()
{
  motor(RIGHT_MOTOR, 100);
  motor(LEFT_MOTOR, 0);
}

void right()
{
  motor(LEFT_MOTOR, 100);
  motor(RIGHT_MOTOR, 0);
}

void dump_data()
{
  int i;

  disable_pcode_serial();

  printf("Press START to send data...\n");
  start_press();

  for (i=0; i< ix; i++) {
    printdec(data[i]);
    serial_putchar(10); serial_putchar(13);
  }

  printf("Done sending data.\n");
  beep();
}