void monitor()
{
    int      reps= 0;  /* frequent repetition count */
    float    last_time= seconds(); /* initialize time */
    float    current_time;
    
    while (1) {
        /* wait until a touch sensor is pressed */
        while (!either_touch_sensor());
        
        /* de-bounce by waiting until release */
        while (either_touch_sensor());
        
        /* capture current time */
        current_time= seconds();
        
        /* if elapsed time is too small, 
           increment repetition count;
           otherwise, set it to zero     */
        if ((current_time - last_time) < 2.0)
          reps++;
        else
          reps= 0;
          
        /* display current rep count */
        printf("Rep count is %d\n", reps);
          
        /* if too many reps, take control */
        if (reps > 5) {
            /* destroy avoid process */
            kill_process(avoid_pid);
            
            /* go backward for one second */
            backward(); sleep(1.0);
            
            /* go right for 0.5 to 1.49 seconds */
            right(); sleep(0.5 + (float)random(100)/100.);
            
            /* launch new avoid process */
            avoid_pid= start_process(avoid());
            
            /* reset repetition counter */
            reps= 0;
        }

        /* save last_time */
        last_time= seconds();
        
    }
}

int either_touch_sensor()
{
    return digital(LEFT_TOUCH) || digital(RIGHT_TOUCH);
}
