ir_routine
        ldx     #$1000
        ldaa    #$40            ; select TOC2 output
        staa    TFLG1,X         ; clear interrupt flag
        
        ldaa    ir_phase
        cmpa    #1
        bne     ir_continue
* phase is 1; that means we're done.
* disable interrupt, set phase to zero, and return.
        bclr    TMSK1,X $40     ; disable TOC2 interrupt
        bra     ir_finish       ; phase decremented to 0
* if phase is even, generate constant-length IR pulse;
* if phase is odd, generate variable-length gap based on data bit,
*       unless phase is 19---generate 3.0 millisecond start bit.
* decrement phase and return.
ir_continue
        rora                    ; odd/even bit in carry
        bcs     ir_odd
* phase is even; set up falling edge for PULSE/2000 milliseconds later
        ldd     TOC2,X
        addd    #PULSE
        std     TOC2,X
        bset    TCTL1,X $80
        bclr    TCTL1,X $40     ; set IR output to go low
        bra     ir_finish
* phase is odd
ir_odd  ldaa    ir_phase
        cmpa    #19
        bne     ir_databit
* generate gap for start bit
        ldd     TOC2,X
        addd    #6000-PULSE     ; 3.0 ms minus pulse length
        bra     ir_sendbit
* generate gap for data bit
ir_databit
        ldd     TOC2,X
        ror     ir_data         ; move lowest data bit into carry
        bcs     ir_onebit
        addd    #2400-PULSE     ; 1.2 ms minus pulse length
        bra     ir_sendbit
ir_onebit addd  #3600-PULSE     ; 1.8 ms minus pulse length
ir_sendbit
        std     TOC2,X
        bset    TCTL1,X $C0     ; set IR output to go high
ir_finish
        dec     ir_phase
        rti
