*********************************************************************
* sonyxmit.asm:  Transmits 8-bit Sony format IR bytes               *
*                                                                   *
* by Fred Martin (fredm@media.mit.edu), August 28, 1997             *
*********************************************************************

CFORC   equ     $100b   ; Timer Compare Force Register
TCNT    equ     $100e   ; Timer Counter Register
TOC2    equ     $1018   ; Timer Output Compare Register 2
TFLG1   equ     $1023   ; main Timer interrupt Flag register 1
TCTL1   equ     $1020   ; Timer Control register 1
TMSK1   equ     $1022   ; main Timer interrupt Mask register 1

TOC2INT equ     $bfe6   ; Timer Output Compare 2 Interrupt Vector

PULSE   equ     1200    ; positive-going IR pulse = 0.6 msec

        org     MAIN_START

ir_phase        fcb     0       ; countdown in transmit sequence
ir_data         fcb     0       ; outgoing byte

subroutine_initialize_module:
        ldd     #ir_routine     ; pointer to driver routine
        std     TOC2INT         ; store at interrupt vector
        clr     ir_phase        ; so we can get going
        rts

* transmits value in B register;
* returns -1 if transmission is already in progress, or
* value called with if successful.
subroutine_sony_xmit:
        ldaa    ir_phase        ; check status
        beq     xmit_setup
        ldd     #$ffff          ; -1 return value
        rts
* make sure that IR transmitter is off;
* set phase countdown to 20;
* create 5 millisecond byte separation delay at start of byte.
xmit_setup
        stab    ir_data         ; store data out byte
        ldx     #$1000          ; pointer to register base
        bset    TCTL1,X $80
        bclr    TCTL1,X $40     ; set IR output to go low
        ldaa    #$40            ; select TOC2 output
        staa    CFORC,X         ; force compare -> output goes low
        staa    TFLG1,X         ; clear interrupt flag  
        ldaa    #20             ; initial phase
        staa    ir_phase
        ldd     TCNT,X
        addd    #10000          ; 5 millisecond delay
        std     TOC2,X
        bset    TCTL1,X $C0     ; set IR output to go high
        bset    TMSK1,X $40     ; enable TOC2 interrupt
        clra                    ; clear A register for return
        ldab    ir_data
        rts     
