* the ir routine is called whenever a falling edge
* (i.e., beginning of valid ir signal) is received
ir_routine
        ldaa    #4
        staa    TFLG1           ; clear tic1 interrupt flag
        
        ldaa    ir_timer
        cmpa    #4
        bls     irgetbit        ; get bit if < 5 ms have elapsed
irreset ldaa    #9              ; capture 9 bits (8 data + 1 start)
        staa    ir_phase
        bra     ircapture

irgetbit ldaa   ir_phase        ; if ir_phase is zero, don't read bit
        beq     ircapture       ; didn't get 5ms gap between bytes
        ldd     TIC1
        subd    last_captured_input
        cmpd    #3000
        ror     ir_shift        ; shift carry bit into answer
        dec     ir_phase
        bne     ircapture       ; continue until all bits read

irdone  ldaa    ir_shift        
        coma                    ; ones complement the answer
        staa    ir_data
        inc     ir_count
        bne     ircapture
        dec     ir_count        ; max out at 255

ircapture ldd   TIC1
        std     last_captured_input
        clr     ir_timer
        rti

* returns IR value received since last call
subroutine_sony_rcv:
        ldd     ir_count        ; count + data in D
        clr     ir_count
        rts

* call with 1 to turn on; 0 to turn off
subroutine_sony_rcv_init
        ldx     #$1000
        tstb
        beq     sony_off
        bset    TMSK1,X $04     * enable tic1 interrupt
        bset    TCTL2,X $20     * on falling edges (i.e., IR detects)
        bclr    TCTL2,X $10     
        clr     ir_count
        clr     ir_data
        rts
sony_off
        bclr    TMSK1,X $04
        rts