*********************************************************************
* sony_rcv.asm:  decodes the Sony format IR protocol                *
*                                                                   *
* by Brian Silverman                        (bss@media.mit.edu)     *
* modified for Handy Board by Fred Martin (fredm@media.mit.edu)     *
* August 15, 1997                                                   *
*********************************************************************

TIC1    EQU     $1010   ; Timer Input Capture register 1
TFLG1   EQU     $1023   ; main Timer interrupt Flag register 1
TCTL2   EQU     $1021   ; Timer Control register 2
TMSK1   EQU     $1022   ; main Timer interrupt Mask register 1

TOC4INT EQU     $E2     ; Timer Output Compare 4
TIC1INT EQU     $EE     ; Timer Input Capture 1

        org     MAIN_START

ir_timer                fcb     0   ; time since last bit
ir_shift                fcb     0   ; received data in progress
ir_phase                fcb     0   ; bits left to receive
ir_count                fcb     0   ; #bytes rcv'd since last check
ir_data                 fcb     0   ; full data byte as received
last_captured_input     fdb     0   ; timestamp of last bit

subroutine_initialize_module:
        ldx     #$bf00          ; pointer to interrupt vectors

* install IR detection routine
        ldd     #ir_routine
        std     TIC1INT,X

* install millisec routine
        ldd     TOC4INT,X               
        std     millisec_exit+1         ; record previous vector
        ldd     #millisec_routine
        std     TOC4INT,X               ; install new vector

        rts

* count up to 256 ms to receive single IR byte;
* otherwise clear incoming data
millisec_routine
        inc     ir_timer
        bne     millisec_exit
        dec     ir_timer        ; ir_timer is 255 now

millisec_exit
        JMP     $0000   ; this value poked in by init routine

