* sertest.asm
* demonstrates 68HC11 serial communications interface (SCI)
* receives a character, and then re-transmits its value + 1

BAUD    equ     $102b	; baud rate reg
SCCR2   equ     $102d	; SCI ctrl reg #2
SCSR    equ     $102e	; SCI status reg
SCDR    equ     $102f	; SCI data reg

        org     $8000
        
start
        lds     #$ff    ; set stack for subroutines

* initialize SCI
        ldaa    #$30    ; value for 9600 baud with an 8 MHz xtal
        staa    BAUD
        ldaa    #$0c    ; turn on xmit and rcv enable bits
        staa    SCCR2
        
loop    bsr     rcv_char
        inca
        bsr     xmit_char
        bra     loop
        
* send char in A register (destroys B register)
xmit_char:
        ldab    SCSR    ; first check if ready
        andb    #$40    ; bit 6 is transmit complete flag
        beq     xmit_char ; wait until TC flag is 1
        staa    SCDR    ; transmit A register
        rts

* get char into A register
rcv_char:
        ldaa    SCSR    ; first check if ready
        anda    #$20    ; bit 5 is receive data register full flag
        beq     rcv_char ; wait until RDRF flag is 1
        ldaa    SCDR    ; get received char (auto-clears RDRF flag)
        rts

        org     $bffe   ; RESET vector
        fdb     start
