/*
    serialio.c 

    allows user Interactive C programs
    to send and receive serial data
*/    

/* allows user programs to receive serial data */
void disable_pcode_serial()
{
   poke(0x3c, 1);
}

/* allows board interaction with IC on host computer */
void enable_pcode_serial()
{
   poke(0x3c, 0);
}

void serial_putchar(int c)
{
   /* wait until serial transmit empty */
   while (!(peek(0x102e) & 0x80));

   /* send character */
   poke(0x102f, c);
}


int serial_getchar(int c)
{
   /* wait until a character is received */
   while (!(peek(0x102e) & 0x20));

   /* return it */
   return peek(0x102f);
}
