*********************************************************************
* sensproc.asm                                                      *
*                                                                   *
* sensor history data processing package                            *
* analyzes data captured by senshist.asm                            *
*                                                                   *
* Fred Martin        fredm@media.mit.edu        7 February 1998     *
*********************************************************************

* array data structure offsets
A_LENGTH        equ     0       ; # of elements in A
A_ARG           equ     2       ; argument to various history fcns
A_TMASK         equ     4       ; timing mask
A_SENSNUM       equ     5       ; sensor number
A_MAX           equ     6       ; alltime max sensor val
A_MIN           equ     7       ; alltime min
A_DATASTART     equ     8       ; ptr to beginning of data area
A_DATAEND       equ     10      ; ptr to end of data area
A_RINGSTART     equ     12      ; ring of data start
A_RINGEND       equ     14      ; ring of data end
A_DATA          equ     16      ; start of actual sensor data


        org     MAIN_START

temp    equ     *               ; data storage
count   fdb     0               ; temp and count are the same
sum     fdb     0

subroutine_alltime_max:
        xgdx
        ldab    A_MAX,x
        clra
        rts
        
subroutine_alltime_min:
        xgdx
        ldab    A_MIN,x
        clra
        rts

subroutine_current_value:
        xgdx
        bsr     get_last_datum
        clra
        rts
        
subroutine_current_min:
        xgdx
        bsr     get_last_datum
        stab    temp
cmi_loop bsr    get_prev_datum
        bcs     cmi_done
        cmpb    temp
        bpl     cmi_loop
        stab    temp
        bra     cmi_loop
cmi_done clra
        ldab    temp
        rts
        
subroutine_current_max:
        xgdx
        bsr     get_last_datum
        stab    temp
cma_loop bsr    get_prev_datum
        bcs     cma_done
        cmpb    temp
        bmi     cma_loop
        stab    temp
        bra     cma_loop
cma_done clra
        ldab    temp
        rts
        
subroutine_sensor_average:
        ldx     #1
        stx     count
        xgdx
        bsr     get_last_datum
        clra
        std     sum

avg_lp  bsr     get_prev_datum
        bcs     avg_done
        pshx
        ldx     count
        inx
        stx     count
        pulx
        clra
        addd    sum
        std     sum
        bra     avg_lp

avg_done ldd    sum
        ldx     count
        idiv
        xgdx

        rts     
        
* iterators for search through ring buffer
* X must point to array start
*
* get_last_datum
*       sets up Y as ptr through ring
*       returns datum in B
* get_prev_datum
*       clears carry if got datum; sets carry if done
*       returns datum in B
get_last_datum:
        ldy     A_RINGEND,x
        
get_prev_datum:
        cpy     A_DATASTART,x   ; check for wrap
        bne     gnd_ok
        ldy     A_DATAEND,x     ; wrap backward
gnd_ok  dey             ; count backward from RINGEND
        ldab    0,y
        cpy     A_RINGSTART,x   ; check for last
        bne     gnd_clc
        sec
        rts
gnd_clc clc
        rts     

