/* senshist.c:  driver functions for senshist.asm */
/* Fred Martin  fredm@media.mit.edu    6 feb 1998 */

int _freq_table[]= {0b00000000,     /* 0-> 62.5 Hz */
                    0b00000001,     /* 1-> 31.25 Hz */
                    0b00000011,     /* 2-> 15.625 Hz */
                    0b00000111,     /* 3-> 7.8125 Hz */
                    0b00001111,     /* 4-> 3.906 Hz */
                    0b00011111,     /* 5-> 1.953 Hz */
                    0b00111111,     /* 6-> 0.977 Hz */
                    0b01111111,     /* 7-> 0.488 Hz */
                    0b11111111};    /* 8-> 0.244 Hz */

/* arguments:
   array_ptr[]  integer array of not fewer than 8 items
   sensor_num   0 to 6 sensor input to keep history (7 is knob)
   frequency    rate of sensor sampling (see table above)
*/   
int install_sensor_history(int array_ptr[], 
                           int sensor_num,
                           int frequency) {
    if (frequency > 8)  {
        printf("freqency out of range\n");
        return -1;
    }
    array_ptr[1]= sensor_num + (_freq_table[frequency] << 8);
    return _install_sensor_history((int)array_ptr);
}

/* to change frequency after history is installed */
int set_history_frequency(int array_ptr[], int frequency)  {
    if (frequency > 8)  {
        printf("freqency out of range\n");
        return -1;
    }
    array_ptr[1]= (array_ptr[1] && 0xff) + (_freq_table[frequency] << 8);
}

/* functions in senshist.asm
   clear_history(int array_ptr)     erases all data in history array
   
   functions in sensproc.asm
   alltime_min(int array_ptr)       smallest value ever recorded 
   alltime_max(int array_ptr)       largest value recorded
   sensor_min(int array_ptr)        smallest value presently recorded
   sensor_max(int array_ptr)        largest value presently recorded
   current_value(int array_ptr)     last sample taken
   sensor_average(int array_ptr)    average of presently recorded vals
*/   
