*********************************************************************
* senshist.asm                                                      *
*                                                                   *
* sensor history package                                            *
*                                                                   *
* Fred Martin        fredm@media.mit.edu        7 February 1998     *
*********************************************************************

* 6811 registers
PORTA           equ     $1000
ADCTL           equ     $1030   ; A/D Control/status Register
ADR1            equ     $1031   ; A/D Result Register 1
TOC4INT         equ     $BFE2   ; Timer Output Compare 4

* zero-page global variables
system_time_lo  equ     $14

* array data structure offsets
A_LENGTH        equ     0       ; # of elements in A
A_ARG           equ     2       ; unused at present
A_TMASK         equ     4       ; timing mask
A_SENSNUM       equ     5       ; sensor number
A_MAX           equ     6       ; alltime max sensor val
A_MIN           equ     7       ; alltime min
A_DATASTART     equ     8       ; ptr to beginning of data area
A_DATAEND       equ     10      ; ptr to end of data area
A_RINGSTART     equ     12      ; ring of data start
A_RINGEND       equ     14      ; ring of data end
A_DATA          equ     16      ; start of actual sensor data

        org     MAIN_START
        
* internal data structures
local_time      fcb     0       ; low byte of (sys time / 16)

plist_start     fdb     0       ; ptr list of sensor data arrays
                fdb     0       ; 2
                fdb     0       ; 3
                fdb     0       ; 4
                fdb     0       ; 5
                fdb     0       ; 6
plist_end       fdb     0       ; 7

* install module into 1 kHz IC system interrupt on TOC4
subroutine_initialize_module:
        ldd     TOC4INT                 ; ptr to original vector
        std     interrupt_code_exit+1   ; install for our exit
        ldd     #interrupt_code_start   ; ptr to our routine
        std     TOC4INT                 ; install at TOC4 int
* zero out list of installed array ptrs
        ldx     #plist_start
        clra    
clrloop staa    0,x
        inx
        cpx     #plist_end+1
        bne     clrloop
        rts

subroutine__install_sensor_history
* find 1st empty slot in ptr list
        pshb
        psha                    ; save incoming array ptr
        ldx     #plist_start
instlp  ldd     0,x
        beq     install
        inx
        inx
        cpx     #plist_end+2
        bne     instlp
* ran out of slots - abort and return 0
        pulx
        clra
        clrb
        rts     
* install, init, and return 
install pula
        pulb
        std     0,x
* set up DATASTART and DATAEND ptrs
* D has ptr to array; copy to X
        pshb
        psha
        pulx
* start of data = x + A_DATA
        addd    #A_DATA                 ; D already has array ptr
        std     A_DATASTART,x
* end of data = x + (array count * 2) + 2
        stx     A_DATAEND,x
        ldd     A_LENGTH,x
        lsld
        addd    #2
        addd    A_DATAEND,x
        std     A_DATAEND,x

* put array ptr back in D, and
* fall into subroutine_clear_history to finish init and return
        xgdx                    
        
subroutine_clear_history:
* D has ptr to array; transfer to X
        pshb
        psha
        pulx
* set RINGSTART and RINGEND to point at DATA
        addd    #A_DATA
        std     A_RINGSTART,x
        std     A_RINGEND,x
* set min and max
        clra    
        staa    A_MAX,x
        ldaa    #255
        staa    A_MIN,x
* return with array addr for confirmation
        xgdx    
        rts

interrupt_code_start:
* first check if low 4 bits of system time are zero
* (max frequency 62.5 Hz)
        ldd     system_time_lo
        andb    #%00001111
        bne     interrupt_code_exit
        
* save "local time" -- sys time shifted down 4 bits
        ldd     system_time_lo
        lsrd
        lsrd
        lsrd
        lsrd
        stab    local_time
        
* for each array in plist, do it
        ldx     #plist_start
plistlp ldd     0,x
        beq     interrupt_code_exit
        bsr     do_array
        inx
        inx
        cpx     #plist_end+2
        bne     plistlp

interrupt_code_exit:
        jmp     $0000   ; value poked in by init routine

* D is ptr to array
* X is ptr into array ptr list; must be preserved on return
do_array
* save X, transfer D into X
        pshx
        xgdx
* check mask with local time
        ldaa    local_time
        anda    A_TMASK,x
        bne     a_done
        
* take sensor reading
        ldaa    A_SENSNUM,x
        staa    ADCTL
* wait 30 cycles for analog reading to happen
        ldab    #6              ; 2
waitlp  decb                    ; 2
        bne     waitlp          ; 3
        ldaa    ADR1            ; get analog read
* store A into array
        bsr     ring_insert
* test for max:  if A - current MAX > 0, have new max
        cmpa    A_MAX,x
        bcs     testmin
        staa    A_MAX,x
testmin cmpa    A_MIN,x
        bcc     a_done
        staa    A_MIN,x

a_done  pulx
        rts

* Structure of Ring Buffer
*
* if RINGSTART=RINGEND, there is no data
* insert data at RINGEND and then advance it, so RINGEND always points
*   where the next datum will go
* if RINGEND advances beyond end of array size, point it at A_DATA
* if RINGEND advances into RINGSTART, advance RINGSTART
* if RINGSTART advances beyond end of array size, point it at A_DATA

* A has byte to insert
* X is ptr to array 
ring_insert
        psha    ; save sensor value
        ldy     A_RINGEND,x
        staa    0,y
        iny
* if y = DATAEND, must reset y to DATASTART
        cpy     A_DATAEND,x
        bne     storeend
        ldy     A_DATASTART,x
storeend
* y now has legit value for new RINGEND
        sty     A_RINGEND,x
* check if y equals RINGSTART; if so, advance RINGSTART
        cpy     A_RINGSTART,x
        bne     ri_done
* advance RINGSTART
        ldy     A_RINGSTART,x
        iny
        cpy     A_DATAEND,x
        bne     storestart
        ldy     A_DATASTART,x
storestart
        sty     A_RINGSTART,x                   
ri_done pula    ; restore sensor value
        rts
