/*
  rpm.c

  uses 6811's pulse accumulator input (PAI)
  to facilitate high-speed counting of transitions
  
  the PAI is sensor input 9 on the Handy Board
*/

int     PACTL=  0x1026; /* pulse accumulator control */
int     PACNT=  0x1027; /* pulse accumulator count */
int     PAEN=   0x40;   /* bit to enable counting */

int rpm()
{
  long end_time;
  int hi_count= 0;
  int last_count= 0;

  bit_set(PACTL, PAEN);         /* enable counting */
  poke(PACNT, 0);               /* reset to 0 */
  end_time= mseconds() + 6000L; /* 6 sec */

  while (mseconds() < end_time) {
    if (peek(PACNT) < last_count) hi_count++;
    last_count= peek(PACNT);
  }

  bit_clear(PACTL, PAEN);       /* disable counting */

  /* report result in revolutions per minute */
  return 10 * (hi_count * 256 + last_count);
}
