/* remctrl.c:  sample LEGObug program for responding to IR signals */
/* requires turtle.c, sony_rcv.icb */

/* Fred Martin  August 18, 1997 */

void main() {
  
  int data, count, ir;
  
  sony_rcv_init(1);                 /* enable IR reception */
    
  while (1) {
    ir= sony_rcv(0);
    
    data= ir & 0xff;                /* mask data field */
    count= ir >> 8;                 /* get count field */
    
    printf("count %d data %d\n", count, data);

    if (count > 0) {
      if (data == 129) forward();   /* 2 key */
      if (data == 131) left();      /* 4 key */
      if (data == 133) right();     /* 6 key */
      if (data == 135) backward();  /* 8 key */
      sleep(0.5); stop();           /* go for 1/2 sec */
    }
  }
}
