*************************************************************************
*									*
* read_ir.asm								*
*									*
* uses: waits for IR signal, then captures time series of IR data       *
*       call with pointer to character array for captured data          *
* 									*
* Fred Martin								*
* fredm@media.mit.edu							*
* 29 July 1997    							*
*									*
*************************************************************************

BASE	equ	$1000	; register base

PORTA	equ	$1000	; Port A data register
PACTL	equ	$1026	; Pulse Accumulator Control register

	ORG	MAIN_START

* sends a byte at 9600 N-8-1 over port A, bit 7
subroutine_read_ir:
	pshb			
	psha			; array pointer in D
	pulx			; transfer array pointer X
	ldd	0,x		; load array count into D
	pshb
	psha
	puly			; transfer count into Y
	inx
	inx			; advance X to point at array data

	sei			; disable interrupts

waitedge 
	ldaa	BASE
	anda	#4		; mask IR bit
	bne	waitedge	; normally true, wait for false

* 50 cycles, or 25 usec per sample
mainloop
	ldaa	BASE		; 4 cycles
	anda	#4		; 2
	lsra			; 2
	lsra			; 2 shift bit into lowest position
	staa	0,x		; 4 store data in array
	inx			; 3 advance array pointer
	bsr 	delay		; 26 delay to slow data collection rate
	dey			; 4 decrement count
	bne	mainloop	; 3 loop if not zero
	
	cli			; enable interrupts

	rts

* 26 cycles -- 11 (6 bsr + 5 rts) + 15 (pshy, puly, nop, nop)
delay
	pshy			; 5
	puly			; 6
	nop			; 2
	nop			; 2
	rts			; 5
