* encoder interrupt code:
*   check for transition every time called (1000 Hz)
*   calculate velocities at about 16 Hertz (exactly: 1000 / 64 Hz.)
interrupt_code_start:
        ldx     #encoder_table

* get shaft encoder bits
        ldab    DIGIN
        andb    #3              ; mask low bits
        pshb                    ; save it
        lslb                    ; times 2
        abx
        
* add in last state, rotated up 3 bits
        ldab    encoder_state
        lslb
        lslb
        lslb
        abx
        
* get increment from table
        ldd     0,X

**** optional clicking *****
** comment out to silence **
        beq     encoder_add
        pshb
        ldab    PORTA
        eorb    #8      ; piezo bit
        stab    PORTA
        pulb
****************************
encoder_add:    
        addd    variable_encoder10_counts
        std     variable_encoder10_counts       

* save new state
        pulb
        stab    encoder_state   

* calc velocities every 64 calls
        ldaa    system_time_lo+1        ; lowest byte
        anda    #%00111111              ; mask off two high bits
        bne     interrupt_code_exit

* velocities are ticks since last interrupt
        ldd     variable_encoder10_counts
        subd    last_counts
        std     variable_encoder10_velocity
        ldd     variable_encoder10_counts
        std     last_counts

interrupt_code_exit:
        jmp     $0000   ; value poked in by init routine
