*********************************************************************
* quaden10.asm                                                      *
*                                                                   *
* quadrature shaft encoder driver                                   *
* connect encoder to digital inputs 10 and 11                       *
*   (low two bits of digital input port)                            *
*                                                                   *
* Fred Martin        fredm@media.mit.edu        28 October 1996     *
*********************************************************************

* 6811 registers
PORTA           equ     $1000
TOC4INT         equ     $BFE2     ; Timer Output Compare 4

* digital inputs
DIGIN           equ     $7000

* zero-page global variables
system_time_lo  equ     $14

        org     MAIN_START

* IC-accessible variables
variable_encoder10_counts               fdb     0
variable_encoder10_velocity             fdb     0

* internal variables
encoder_state                           fcb     0
last_counts                             fdb     0

* install module into 1 kHz IC system interrupt on TOC4
subroutine_initialize_module:
        ldd     TOC4INT                 ; ptr to original vector
        std     interrupt_code_exit+1   ; install for our exit
        ldd     #interrupt_code_start   ; ptr to our routine
        std     TOC4INT                 ; install at TOC4 int

* reset encoder variables
        ldd     #0
        std     variable_encoder10_counts
        std     variable_encoder10_velocity
        std     last_counts

        ldaa    DIGIN
        anda    #3              ; mask low bits
        staa    encoder_state

        rts
