* pzo_knob.asm
* use knob to control piezo frequency

base    equ     $1000
toc5    equ     $101e           ; timer output 5 match 
tctl1   equ     $1020           ; timer control 1
tmsk1   equ     $1022           ; timer mask 1
tflg1   equ     $1023           ; timer flag 1
adctl   equ     $1030           ; A/D control/status
adr1    equ     $1031           ; A/D result 1
option  equ     $1039           ; system cfg options

        org     0

period  rmb     2

        org     $8000
        
start   lds     #$ff
        ldx     #base
        bset    tctl1,x 1       ; set toc5
        bclr    tctl1,x 2       ;   to toggle on match
        bset    tmsk1,x $08     ; enable interrupt
        bset    tflg1,x $08     ; clear int flag
        cli                     ; globally enable ints
        
        bset    option,x $80    ; turn on A/D cnv

knobloop ldb    #7              ; knob is analog input 7
        bsr     analog
        asld
        asld
        asld                    ; multiply result by 8
        std     period          ; store in varible location
        bra     knobloop

* take analog reading.  sensor port in B, answer in B
analog
        andb    #7              ; keep argument in range
        stab    adctl           ; begin analog conversion
* wait 32 cycles for analog reading to happen
        ldaa    #6              ; 2
waitlp  deca                    ; 2
        bne     waitlp          ; 3
        ldab    adr1            ; get analog read
        rts                     ; B has answer, A has 0

piezoint
        ldx     #base
        ldd     toc5,x          ; get last match point
        addd    period          ; add variable delay
        std     toc5,x          ; store back
        bset    tflg1,x 8       ; clear int flag
        rti                     ; return from interrupt

        org     $bfe0           ; timer output 5 vector
        fdb     piezoint
        
        org     $bffe           ; reset vector
        fdb     start
