/* priority.c:  arbitration program for multi-behavior robot control */

/* define process tables */
int process_priority[10];
int process_enable[10];
char process_name[0][10];

/* define motor output tables */
int left_motor[10];
int right_motor[10];

/* globals */
int num_processes= 0;
int active_process= 0;

/* set process_enable entry to process's priority level */
void enable (int pid) {
  process_enable[pid]= process_priority[pid];
}

/* set process_enable entry to 0 */
void disable (int pid) {
  process_enable[pid]= 0;
}

void prioritize () {
  int max, i;

  while (1)  {
    /* find process with maximum priority */
    max= 0;
    for (i=0; i< num_processes; i++)
      if (process_enable[i] > max) max= process_enable[i];
    
    /* if no processes enabled, turn off motors */
    if (max == 0)  {
      motor(LEFT_MOTOR_PORT, 0); motor(RIGHT_MOTOR_PORT, 0);
      printf("No tasks enabled\n");
    } else {
      /* get pid of active process */
      /* if more than one at highest level, get the first one */
      for (i=0; i< num_processes; i++)
        if (process_enable[i] == max) break;
      active_process= i;

      /* set the motors based on the commands of this process */
      motor(LEFT_MOTOR_PORT, left_motor[active_process]);
      motor(RIGHT_MOTOR_PORT, right_motor[active_process]);
    
      /* display name of active process */
      printf("Running %s\n", process_name[active_process]);
    }
  }
}