/*
  printdec.c
    
  routine to output an integer value
  as a decimal number over the serial line

  requires serialio.c
   
*/    

/* prints number over serial line */
void printdec(int n)
{
  int leading_digit= 0;
  int dig, div;

  for (div= 10000; div= div/10; div> 0) {
    dig= n/div;
    n= n - dig*div;
    if (dig || leading_digit) {
      _printnum(dig);
      leading_digit= 1;
    }
  }
}

/* prints digit from 0 to 9 over serial line */
void _printnum(int n)
{
  serial_putchar(n + '0');
}
