/*
  plegobug.c:  movement and touch sensor commands
                for LEGObug with priority.c
*/                

/* motor and sensor ports */
int LEFT_MOTOR_PORT= 0;
int RIGHT_MOTOR_PORT= 3;
int LEFT_TOUCH_PORT= 7;
int RIGHT_TOUCH_PORT= 8;

/* movement commands */
void forward (int pid) {
  left_motor[pid]= 100;
  right_motor[pid]= 100;
}

void backward (int pid) {
  left_motor[pid]= -100;
  right_motor[pid]= -100;
}

void right (int pid) {
  left_motor[pid]= 100;
  right_motor[pid]= -100;
}

void left (int pid) {
  left_motor[pid]= -100;
  right_motor[pid]= 100;
}

void halt (int pid) {
  left_motor[pid]= 0;
  right_motor[pid]= 0;
}

/* sensor functions */
int left_touch () {
  return digital(LEFT_TOUCH_PORT);
}

int right_touch () {
  return digital(RIGHT_TOUCH_PORT);
}
