* piezoint.asm
* using interrupts to run piezo

base    equ     $1000
toc5    equ     $101e           ; timer output 5 match 
tctl1   equ     $1020           ; timer control 1
tmsk1   equ     $1022           ; timer mask 1
tflg1   equ     $1023           ; timer flag 1

        org     $8000
        
start   lds     #$ff
        ldx     #base
        bset    tctl1,x 1       ; set toc5
        bclr    tctl1,x 2       ;   to toggle on match
        bset    tmsk1,x $08     ; enable interrupt
        bset    tflg1,x $08     ; clear int flag
        cli                     ; globally enable ints

die     bra     die             ; loop doing nothing

piezoint
        ldx     #base
        ldd     toc5,x          ; get last match point
        addd    #1000           ; add 0.5 ms
        std     toc5,x          ; store back
        bset    tflg1,x 8       ; clear int flag
        rti                     ; return from interrupt

        org     $bfe0           ; timer output 5 vector
        fdb     piezoint
        
        org     $bffe           ; reset vector
        fdb     start
