* mtrdrive.asm
* sample motor interface library

MOTORS  equ     $7000   ; address of motor chip latch

        org     0
        
motorbits rmb   1       ; copy of motor state bits
*                       ; high 4 bits are on/off, low 4 are dir

        org     $8000
        
start
        lds     #$ff    ; set up stack for subroutines
        
        bsr     alloff          ; initialize motors off

mainloop 
        ldaa    #0
        bsr     motoron         ; turn on motor 0

        ldx     #500
        bsr     delayms         ; wait 0.5 sec

        ldaa    #0
        bsr     motoroff        ; turn off motor 0

        ldx     #500
        bsr     delayms         ; wait 0.5 sec
        
        ldaa    #0
        bsr     motorrd         ; reverse motor 0 for next time

        ldaa    #3
        bsr     motorbk         ; set motor 3 for backward

        ldaa    #3
        bsr     motoron         ; turn on motor 3

        ldx     #500
        bsr     delayms         ; wait 0.5 sec

        ldaa    #3
        bsr     motorfd         ; set motor 3 for forward
        
        ldx     #500
        bsr     delayms         ; wait 0.5 sec

        ldaa    #3
        bsr     motoroff        ; turn off motor 3

        bra     mainloop        ; repeat

* resets motors to off
alloff:
        clra
        bsr     store_motors

* call with motor to be turned on in A
motoron:
        bsr     select_onoff_bit
        oraa    motorbits       ; turn on selected on/off bit
        bra     store_motors

motoroff:
        bsr     select_onoff_bit
        coma                    ; invert to all 1's except selected bit
        anda    motorbits       ; set selected bit to 0
        bra     store_motors

* "forward" direction has dir bit off
motorfd:
        bsr     select_dir_bit
        coma
        anda    motorbits       ; set selected bit to 0
        bra     store_motors
        
* "backward" direction has dir bit on
motorbk:
        bsr     select_dir_bit
        oraa    motorbits
        bra     store_motors

* reverse the direction (rd) by exclusive-OR'ing the dir bit
motorrd:
        bsr     select_dir_bit
        eora    motorbits
        bra     store_motors
        
* accepts motor byte in A;
* writes it to motorbits variable and hardware latch
store_motors:
        staa    motorbits
        staa    MOTORS
        rts

* selects on/off bit from motor number
* takes 0 to 3 in A, returns 0: $10, 1: $20, 2: $40, 4: $80 in A
select_onoff_bit:
        inca                    ; make range of A from 1 to 4
        ldab    #$08            ; motor 0 position after one shift
sob20   lslb                    ; shift B up by one bit position
        deca
        bne     sob20
* B has answer
        tba                     ; transfer B to A
        rts
        
* selects dir bit from motor number
* takes 0 to 3 in A, returns 0: $01, 1: $02, 2: $04, 3: $08 in A
select_dir_bit:
        inca                    ; put range of A from 1 to 4
        clrb                    ; clear result
        sec                     ; set carry, will get rotated into B
sdb20   rolb                    ; B is $01 after one rotate
        deca
        bne     sdb20
        tba
        rts

* delays specified num of milliseconds (from X register)
* returns with X = 0, B = 0
delayms:
* delay 1 ms, or 2000 cycles
        ldab    #222            ; 9 in loop x 222 = 1998
dms20   decb                    ; 2 cycles
        nop                     ; 2 cycles
        nop                     ; 2 cycles      
        bne     dms20           ; 3 cycles
* test X and repeat till done
        dex
        bne     delayms
        rts

        org     $bffe           ; reset vector
        fdb     start
        