/* 
   linehist.c:  automatically set line thresholds
   based on average sensor reading
   requires senshist.lis package
*/   

int line[50];   /* buffer to hold sensor history */
int LINE_THRESHOLD;

void main() {
    start_process(compute_and_display());
    line_follow();
}

void line_follow() {
    while (1) {
        waddle_left();
        waituntil_on_the_line(); waituntil_off_the_line();
        waddle_right();
        waituntil_on_the_line(); waituntil_off_the_line();
    }
}

void waituntil_on_the_line() {
    while (line_sensor() < LINE_THRESHOLD);
}

void waituntil_off_the_line() {
    while (line_sensor() > LINE_THRESHOLD);
}

int line_sensor() {
    return current_value((int)line);
}

void waddle_left() {
    fd(3); off(0);
}

void waddle_right() {
    fd(0); off(3);
}

void compute_and_display() {
    install_sensor_history(line, 0, 3);
    while (1) {
        LINE_THRESHOLD= sensor_average((int)line);
        printf("thresh %d line %d\n",
               LINE_THRESHOLD, current_value((int)line));
        msleep(50L);
    }
}
