/* 
   lineauto.c:  automatically set line thresholds
   based on maximum and minimum readings
*/   

int line, LINE_THRESHOLD;
int max=0;
int min=255;

void main() {
    start_process(display());
    line_follow();
}

void line_follow() {
    while (1) {
        waddle_left();
        waituntil_on_the_line(); waituntil_off_the_line();
        waddle_right();
        waituntil_on_the_line(); waituntil_off_the_line();
    }
}

void waituntil_on_the_line() {
    while (line_sensor() < LINE_THRESHOLD);
}

void waituntil_off_the_line() {
    while (line_sensor() > LINE_THRESHOLD);
}

int line_sensor() {
    line= analog(0);
    if (line > max) max= line;
    if (line < min) min= line;
    LINE_THRESHOLD= (max + min) / 2;
    return line;
}

void waddle_left() {
    fd(3); off(0);
}

void waddle_right() {
    fd(0); off(3);
}

void display() {
    while (1) {
        printf("max %d min %d thresh %d line %d\n",
               max, min, LINE_THRESHOLD, line);
        msleep(50L);
    }
}
