/*
  the normalize routine converts the raw reading of a photocell sensor
  (typically: 10 in bright light; 200 in dark light) into values
  appropriate for controlling the motors (0= off; 100= full speed
  forward).
*/  

int normalize(int value)
{
    int bright= 10;
    int dark= 200;
    int output= 100 - ((value - bright) * 100) / (dark - bright);

    if (output < 0) output= 0;
    if (output > 100) output= 100;

    return output;
}
