/*
    legobug1.c
*/

/*  motor ports  */
int     LEFT_MOTOR=     0;
int     RIGHT_MOTOR=    3;

/*  sensor ports  */
int     LEFT_EYE=       0;
int     RIGHT_EYE=      1;

void main()
{
    while (1) {

        /* set speed of left motor based on right eye */
        motor(LEFT_MOTOR, normalize(analog(RIGHT_EYE)));

        /* set speed of right motor based on left eye */
        motor(RIGHT_MOTOR, normalize(analog(LEFT_EYE)));

    }
}

/*
  the normalize routine converts the
  raw reading of a photocell sensor
  (typically: 10 in bright light; 200 in dark light)
  into values appropriate for controlling the motors
  (0= off; 100= full speed forward).
*/  

int normalize(int value)
{
    int bright= 10;
    int dark= 200;
    int output= 100 - ((value - bright) * 100) /
                (dark - bright);

    if (output < 0) output= 0;
    if (output > 100) output= 100;

    return output;
}
