* lcdtest.asm
* demo of LCD driver located in 68HC11 internal memory

PORTA   equ     $1000
PORTC   equ     $1003   ; Port C latched data register
PORTB   equ     $1004   ; Port B data register
DDRC    equ     $1007   ; Data Direction register for port C
HPRIO   equ     $103c

        org     0
* label for zero page location of driver
lcdwrite                

        org     $8000
        
start   lds     #$ffff          ; establish stack at top of RAM

        bsr     lcdinit         ; transfer LCD driver and init LCD

        ldx     #string1        ; point at first string 
        bsr     putstr          ; write it to LCD!
        
waitstart ldaa  $7000           ; wait till user presses
        anda    #$80            ; the start button
        bne     waitstart
        
        bsr     lcdcls          ; clear the LCD
        ldx     #string2        ; point to 2nd string
        bsr     putstr          ; write it!

die     bra     die             ; we're done

string1 fcc     'Press start...'
        fcb     0
        
string2 fcc     'Goodbye!'
        fcb     0


* putstr: call with X pointing to zero-terminated string
putstr  ldab    0,x             ; fetch char
        beq     putstr90        ; test for done
        bsr     putchar         ; write to LCD
        inx                     ; increment ptr
        bra     putstr          ; try again
putstr90 rts    

* putchar: writes B as a single char to the LCD
putchar
        pshx                    ; save X register
        ldaa    #2              ; control for normal char
        jsr     lcdwrite        ; call LCD driver routine
        pulx                    ; restore X register
        rts

* lcdinit: call to load driver and clear LCD screen
lcdinit
        bsr     loaddriver      ; intall driver into zero page 
        ldd     #$0038          ; 8-bit operation, 2-line display
        jsr     lcdwrite        ; do it
        ldab    #%00001100      ; display on, cursor & blink off
        jsr     lcdwrite        
* fall into lcdcls      

* lcdcls:  call to clear LCD screen
lcdcls
        ldd     #$0001          ; home and clear screen
        jsr     lcdwrite
        ldab    #$06            ; set to increment char loc & cursor pos
        jsr     lcdwrite
        ldab    #$02            ; home cursor
        jsr     lcdwrite
        rts

* loaddriver: copy driver to zero page memory
loaddriver
        ldx     #driverstart    ; point to source
        ldy     #lcdwrite       ; destination
load20
        ldaa    0,x             
        staa    0,y             ; copy one byte
        inx
        iny                     ; increment ptrs
        cpx     #driverend
        bne     load20          ; until done
        rts

* zero page LCD driver
* copy to zero page RAM, then call with A=command byte, B=data
* X and Y regs are destroyed in use
driverstart
        xgdy                            ; save args in y
        ldx     #$1000
        bclr    HPRIO,x %00100000       ; put into single chip mode
        bclr    PORTA,x %00010000       ; turn off LCD E line
        clr     DDRC,x                  ; make port C input
lcdready
        ldaa    #1
        staa    PORTB                   ; read operation from LCD
        bset    PORTA,x %00010000       ; strobe LCD on
        ldaa    PORTC,x                 ; get status
        bclr    PORTA,x %00010000       ; strobe LCD off
        anda    #$80                    ; bit 7 is busy flag
        bne     lcdready

        ldaa    #$FF
        staa    DDRC,x                  ; make port C output
        xgdy                            ; restore args
        staa    PORTB,x                 ; high byte is control
        stab    PORTC,x                 ; low byte is data
        bset    PORTA,x %00010000
        bclr    PORTA,x %00010000       ; write to LCD

driverexit
        bset    HPRIO,x %00100000       ; put into expanded chip mode
        rts                             ; return 
driverend

* reset vector
        org     $bffe
        fdb     start
