/*
  lb2task.c:  main program for LEGObug and priority.c
              two tasks:  periodic_turn and touch
*/              

void main () {
  int pid= 0;
  
  /* touch sensor */
  process_priority[pid]= 3;
  process_name[pid]= "Touch";
  start_process(touch(pid++));
  
  /* periodic turn */
  process_priority[pid]= 2;
  process_name[pid]= "Turn";
  start_process(periodic_turn(pid++));
  
  /* motor arbitration process */
  num_processes= pid;
  start_process(prioritize());
}

/* periodic turn:  every 10 secs, turn a bit */
void periodic_turn (int pid) {
  while (1) {
    if (((int)seconds() % 10) == 9) {
      enable(pid);
      right(pid); msleep(500L);
      disable(pid);
      msleep(500L);
    }
  }
}

/* touch sensor process */
void touch (int pid) {
  while (1) {
    if (left_touch()) {
      enable(pid);
      backward(pid); msleep(500L);
      right(pid); msleep(500L);
      disable(pid);
    } else if (right_touch()) {
      enable(pid);
      backward(pid); msleep(500L);
      left(pid); msleep(500L);
      disable(pid);
    }
  }
}
