***********************************************************************
* khz30pd2.asm                                                        *
*                                                                     *
* uses: transmits 30 kHz square wave on Port D, bit 2 (MISO)          *
*       takes argument: number of cycles to transmit                  *
*       (0= 256 cycles, 1 = 1 cycle, 255= 255 cycles)                 *
*       returns: port A in high byte and digital inputs in low byte   *
*                                                                     *
* Fred Martin     fredm@media.mit.edu         18 June 1997            *
***********************************************************************

pdbit   equ     4       ; bit of port D to be used

digins  equ     $7000   ; digital inputs

base    equ     $1000   ; 6811 register base
porta   equ     $1000
portd   equ     $1008
ddrd    equ     $1009

        org     MAIN_START

subroutine_khz30pd2
        sei                     ; disable interrupts
*                                 to gain complete control of CPU
        ldx     #base
        bset    ddrd,x pdbit    ; enable Port D bit for output
        
* B register contains count argument
* 30 kHz is 33.33 usec per oscillation
* 6811 runs at 0.5 usec per machine cycle
* inner loop is 66.7 (round to 67) machine cycles
loop    bset    portd,x pdbit   ; 7 cycles= 3.5 us
        bsr     kill20          ; 20 (6 for bsr + 14 more)
        brn     loop            ; 3
        brn     loop            ; 3 making 33 so far
        bclr    portd,x pdbit   ; 7
        bsr     kill20          ; 20
        nop                     ; 2
        decb                    ; 2
        bne     loop            ; 3
*                                 = 67 total
        
        ldaa    porta           ; return port A in high byte
        ldab    digins          ; and digital inputs in low byte

        cli                     ; enable interrupts

        rts

kill20  pshx                    ; 4
        pulx                    ; 5
        rts                     ; 5
