*********************************************************************
* gp2d02.asm                                                        *
*                                                                   *
* uses: reads data byte out of Sharp GP2D02 optical distance sensor *
*       assumes output to Sharp is Port D2, input from Sharp is D3  *
*                                                                   *
* Fred Martin        fredm@media.mit.edu        1 January 1998      *
*********************************************************************

BASE    equ     $1000   ; register base
PORTD   equ     $1008   ; Port D data register
DDRD    equ     $1009   ; Port D data direction register

GPOUT   equ     $04     ; output to Sharp GP2D02
GPIN    equ     $08     ; input from Sharp GP2D02

        ORG     MAIN_START

subroutine_initialize_module:
        ldx     #BASE   ; ptr to regs
        bset    PORTD,X GPOUT
        bset    DDRD,X GPOUT
        rts

subroutine_gp2d02_talk:
        ldx     #BASE   ; ptr to regs   
        sei             ; disable interrupts for precise timing
        
* perform setup pulse
        bset    PORTD,X GPOUT
        bclr    PORTD,X GPOUT
        
        clrb            ; B reg will have answer
        ldaa    #8      ; loop 8 times to get data out  
gploop  brclr   PORTD,X GPIN gpl50      ; test sensor output
        incb            ; if bit was high, add to result

gpl50   bset    PORTD,X GPOUT
        bclr    PORTD,X GPOUT
        
        deca
        beq     gpdone
        aslb            ; shift result up
        bra     gploop
        
gpdone  bset    PORTD,X GPOUT   ; disable sensor on exit
        cli             ; re-enable interrupts
        rts             ; A is zero, B has result