/* define exit codes */
int NORMAL= 0;
int TIMEOUT= 1;
int EARLY= 2;
int VL_STUCK= 3;
int VR_STUCK= 4;
int GS_STUCK= 5;

/* sample timing parameters */
long TOO_LONG= 4000L;
long TOO_SHORT= 1500L;
long VL_TIME= 2000L;
long VR_TIME= 2000L;
long GS_TIME= 3000L;

int follow_edge_to_wall()  {
  
  long start= mseconds();
  long timeout= start + TOO_LONG;
  int last_mode= 0;
  long last_time= 0;

  while (1)  {
    if (left_eye() == 0)  {
      veer_left();
      if (last_mode == VL_STUCK)
        if ((mseconds() - last_time) > VL_TIME)
          return VL_STUCK;
      else  {
        last_mode= VL_STUCK;
        last_time= mseconds();
      }
    }
    
    else if (right_eye() == 1) {
      veer_right();
      if (last_mode == VR_STUCK)
        if ((mseconds() - last_time) > VR_TIME)
          return VR_STUCK;
      else  {
        last_mode= VR_STUCK;
        last_time= mseconds();
      }
    }
    
    else {
      forward();
      if (last_mode == GS_STUCK)
        if ((mseconds() - last_time) > GS_TIME)
          return GS_STUCK;
      else  {
        last_mode= GS_STUCK;
        last_time= mseconds();
      }
    }

    if (left_touch() || right_touch())
      if (mseconds() < (start + TOO_SHORT))
        return EARLY;
      else return NORMAL;

    if (mseconds() > timeout) return TIMEOUT;
  }
}
