/*
  datacoll.c
  data collection and printing

  requires printdec.c, serialio.c
*/    

int SAMPLES=1000;
char data[1000];

void main()
{
  disable_pcode_serial();

  printf("press Start to  collect data\n");
  start_press();
  collect_data();
  beep();

  printf("press Start to  dump data\n");
  start_press();
  dump_data();
  beep();

  printf("done.\n");
}

void collect_data()
{
  int i;
	
  for (i= 0; i< SAMPLES; i++) {
    data[i]= analog(0);
    /* to slow down capture rate, add msleep here */
  }
}

void dump_data()
{
  int i;
	
  for (i= 0; i< SAMPLES; i++) {
    printdec(data[i]);
    serial_putchar(10);        /* line feed */
    serial_putchar(13);        /* carriage return */
  }
}
