/*  
    main routine from bugcand.c
*/    

void main()
{
    while (1) {

        /* set speed of left motor based on right eye */
        motor(LEFT_MOTOR, normalize(analog(RIGHT_EYE)));

        /* set speed of right motor based on left eye */
        motor(RIGHT_MOTOR, normalize(analog(LEFT_EYE)));
        
        /* check for touch sensors */
        if (digital(LEFT_TOUCH)) {
            backward();
            sleep(.25);
            right();
            if (random(4) == 0) {
                set_beeper_pitch(1000.); 
                beeper_on();
                sleep((float)random(100)/100. + .5);
                beeper_off();
            } else {
                sleep(.4);
            }
        }
        
        if (digital(RIGHT_TOUCH)) {
            backward();
            sleep(.25);
            left();
            if (random(4) == 0) {
                set_beeper_pitch(1000.); 
                beeper_on();
                sleep((float)random(100)/100. + .5);
                beeper_off();
            } else {
                sleep(.4);
            }
        }
    }
}
