* beepint.asm beeper demonstration program using interrupts

TCNT    equ     $100e           ; Timer Counter register
TOC5    equ     $101e           ; Timer Output Compare 5 register
TCTL1   equ     $1020           ; Timer Control register 1
TMSK1   equ     $1022           ; Timer Mask register 1
TFLG1   equ     $1023           ; Timer Flag register 1

PIEZO   equ     8               ; position of beeper line

        org     $8000

start
        lds     #$ff            ; initialize stack
        ldx     #$1000          ; ptr to register base

        bset    TCTL1,x %00000001
        bclr    TCTL1,x %00000010 ; set TOC5 to toggle on interrupt
        
        bset    TMSK1,x PIEZO   ; enable TOC5 interrupt
        
        cli                     ; globally enable interrupts

loop    bra     loop            ; main loop of program does nothing!

beepisr                         
        ldd     TOC5            ; get the last compare value
        addd    #1000           ; add 1000 (500 microseconds)
        std     TOC5            ; store back for next compare

        ldaa    #PIEZO          ; other method to clear
        staa    TFLG1           ; the TOC5 flag

        rti                     ; return from interrupt

        org     $bfe0           ; TOC5 interrupt vector
        fdb     beepisr         ; beeper interrupt service routine

        org     $bffe           ; reset vector
        fdb     start
