* asmtest2.asm, demonstrating subroutines and delay loops

        org $8000       define program origin at address $8000

start   lds #$ffff      ; define program stack at very top of memory
        
again
        ldaa #$f0       ; load the value $f0 into the A register
        staa $7000      ; store the A reg to $7000, the motor port
        
        jsr delay       ; insert delay
        
        ldaa #$ff       ; other motor direction
        staa $7000      ; write to motor port
        
        jsr delay
        
        bra again       ; repeat indefinitely

delay   ldx #0          ; put zero into X register
delaylp dex             ; subtract 1 from X
        bne delaylp     ; loop until zero again (65536 times)
        rts             ; return from subroutine
        
        org $bffe       ; location of 68hc11 "RESET" vector
        fdb start       ; "form double byte" to start of program
        
        end
