* anlg_tst.asm
* tests analog conversion routine; knob controls motor outs

base    equ     $1000
adctl   equ     $1030           ; A/D control/status
adr1    equ     $1031           ; A/D result 1
option  equ     $1039           ; system cfg options

        org     $8000           ; start of Handy Board RAM
        
start   lds     #$ff            ; set up stack pointer
        ldx     #base
        bset    option,x $80    ; turn on A/D cnv

knobloop ldb    #7              ; knob is analog input 7
        bsr     analog          ; get analog conversion
        cmpb    #128            ; compare to 128
        bhi     motorsgreen     ; branch if was higher than 128
motorsred
        ldaa    #$ff            ; byte to set all motors red
        bra     storemotors     
motorsgreen     
        ldaa    #$f0            ; byte to set motors green
storemotors
        staa    $7000           ; store motor ctrl byte
        bra     knobloop        ; do it again

* take analog reading.  sensor port in B, answer in B
analog
        andb    #7              ; keep argument in range
        stab    adctl           ; begin analog conversion
* wait 32 cycles for analog reading to happen
        ldaa    #6              ; 2
waitlp  deca                    ; 2
        bne     waitlp          ; 3
        ldab    adr1            ; get analog read
        rts                     ; B has answer, A has 0

        org     $bffe           ; reset vector
        fdb     start
