* analog.asm demonstration of analog conversion

ADCTL   equ     $1030   ; A/D Control/Status register
ADR1    equ     $1031   ; A/D Result register 1
OPTION  equ     $1039   ; System Configuration Options register

        org     $8000

start
        lds     #$ff            ; establish stack for subr calls
        
        ldx     #$1000          ; register base ptr
        bset    OPTION,X $80    ; enable A/D subsystem!

loop
        ldab    #7              ; knob is port E7
        bsr     analog          ; get analog reading
        stab    $7000           ; write it to motor port
        bra     loop

analog
        stab    ADCTL           ; begin analog conversion
* wait 32 cycles for analog reading to happen
        ldaa    #6              ; 2
waitlp  deca                    ; 2
        bne     waitlp          ; 3
        ldab    ADR1            ; get analog read
        rts                     ; b has reading, a has 0

        org     $bffe           ; reset vector
        fdb     start
